local KBKeys = {
    KEY_0 = 0x30,
    KEY_1 = 0x31,
    KEY_2 = 0x32,
    KEY_3 = 0x33,
    KEY_4 = 0x34,
    KEY_5 = 0x35,
    KEY_6 = 0x36,
    KEY_7 = 0x37,
    KEY_8 = 0x38,
    KEY_9 = 0x39,
    A = 0x41,
    B = 0x42,
    C = 0x43,
    D = 0x44,
    E = 0x45,
    F = 0x46,
    G = 0x47,
    H = 0x48,
    I = 0x49,
    J = 0x4A,
    K = 0x4B,
    L = 0x4C,
    M = 0x4D,
    N = 0x4E,
    O = 0x4F,
    P = 0x50,
    Q = 0x51,
    R = 0x52,
    S = 0x53,
    T = 0x54,
    U = 0x55,
    V = 0x56,
    W = 0x57,
    X = 0x58,
    Y = 0x59,
    Z = 0x5A,
    F1  = 0x70,
    F2  = 0x71,
    F3  = 0x72,
    F4  = 0x73,
    F5  = 0x74,
    F6  = 0x75,
    F7  = 0x76,
    F8  = 0x77,
    F9  = 0x78,
    F10 = 0x79,
    F11 = 0x7A,
    F12 = 0x7B,
    NUMPAD_0 = 0x60,
    NUMPAD_1 = 0x61,
    NUMPAD_2 = 0x62,
    NUMPAD_3 = 0x63,
    NUMPAD_4 = 0x64,
    NUMPAD_5 = 0x65,
    NUMPAD_6 = 0x66,
    NUMPAD_7 = 0x67,
    NUMPAD_8 = 0x68,
    NUMPAD_9 = 0x69,
    NUMPAD_MULTIPLY = 0x6A,
    NUMPAD_ADD      = 0x6B,
    NUMPAD_SUBTRACT = 0x6D,
    NUMPAD_DECIMAL  = 0x6E,
    NUMPAD_DIVIDE   = 0x6F,
    SHIFT       = 0x10,
    CTRL        = 0x11,
    ALT         = 0x12,
    LSHIFT      = 0xA0,
    RSHIFT      = 0xA1,
    LCTRL       = 0xA2,
    RCTRL       = 0xA3,
    LALT        = 0xA4,
    RALT        = 0xA5,
    LEFT        = 0x25,
    UP          = 0x26,
    RIGHT       = 0x27,
    DOWN        = 0x28,
    INSERT      = 0x2D,
    DELETE      = 0x2E,
    HOME        = 0x24,
    END         = 0x23,
    PAGE_UP     = 0x21,
    PAGE_DOWN   = 0x22,
    ENTER       = 0x0D,
    ESC         = 0x1B,
    TAB         = 0x09,
    SPACE       = 0x20,
    BACKSPACE   = 0x08,
    CAPSLOCK    = 0x14,
    MOUSE_LEFT   = 0x01,
    MOUSE_RIGHT  = 0x02,
    MOUSE_MIDDLE = 0x04
}
local gamepadKeys = {
    DPAD_UP     = 0x0001,
    DPAD_DOWN   = 0x0002,
    DPAD_LEFT   = 0x0004,
    DPAD_RIGHT  = 0x0008,
    Y           = 0x0010,
    X           = 0x0040,
    LB          = 0x0100,
    LT          = 0x0200,
    RB          = 0x0400,
    L3          = 0x1000,
    RT          = 0x0800, 
    R3          = 0x2000, 
    BACK        = 0x4000,
    START       = 0x8000,
    A           = 0x20020,
    B           = 0x40080
}
local config = json.load_file("SwitchViewHotkeys\\config.json")
if config == nil then
    config = {}
    config["GraceKeyboardHotkey"] = "A"
    config["GraceGamepadHotkey"] = "A"
    config["LeonKeyboardHotkey"] = "A"
    config["LeonGamepadHotkey"] = "A"
end
local previous_key_states = {}
local gamepad_previous_buttons = 0
local ChMgr = sdk.get_managed_singleton("app.CharacterManager")
local function SwitchViewGrace()
    if ChMgr == nil then
        ChMgr = sdk.get_managed_singleton("app.CharacterManager")
    end
    if ChMgr then
        local BF = ChMgr:get_field("<SwitchPlayerViewChecker>k__BackingField")
        if BF then
            local Current = BF:get_field("_cp_A100PersonType")
            if Current == 1 then
                Current = 0
            else
                Current = 1
            end
            BF:set_field("_cp_A100PersonType", Current)
        end
    end
end
local function SwitchViewLeon()
    if ChMgr == nil then
        ChMgr = sdk.get_managed_singleton("app.CharacterManager")
    end
    if ChMgr then
        local BF = ChMgr:get_field("<SwitchPlayerViewChecker>k__BackingField")
        if BF then
            local Current = BF:get_field("_cp_A000PersonType")
            if Current == 1 then
                Current = 0
            else
                Current = 1
            end
            BF:set_field("_cp_A000PersonType", Current)
        end
    end
end

--[[sdk.hook(sdk.find_type_definition('app.CharacterManager'):get_method('getPlayerContextID'), function(args)
--For restoring settings, but may not be needed
end)]]

local GamepadNativeSingleton = sdk.get_native_singleton("via.hid.Gamepad")
local GamepadTypeDefinition = sdk.find_type_definition("via.hid.GamePad")
local Gamepad = sdk.call_native_func(GamepadNativeSingleton, GamepadTypeDefinition, "get_MergedDevice")
re.on_frame(function()
    -- detect key press once
    local function is_key_pressed(key)
        local currently_down = reframework:is_key_down(key)
        local was_down = previous_key_states[key] or false
        previous_key_states[key] = currently_down  -- update for next frame
        return currently_down and not was_down  -- True only on first press
    end

    if KBKeys[config["GraceKeyboardHotkey"]] then
        if is_key_pressed(KBKeys[config["GraceKeyboardHotkey"]]) then
            SwitchViewGrace()
        end
    end
    if KBKeys[config["LeonKeyboardHotkey"]] then
        if is_key_pressed(KBKeys[config["LeonKeyboardHotkey"]]) then
            SwitchViewLeon()
        end
    end

    local function is_button_pressed(current_state, previous_state, key)
        return (current_state & key) ~= 0 and (previous_state & key) == 0
    end

    if Gamepad then
        local button_state = Gamepad:call("get_Button")
        local lb_held = (button_state & gamepadKeys.LB) ~= 0
        local a_pressed = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys.A)
        local AnyPressedGrace = false
        if config and gamepadKeys[config["GraceGamepadHotkey"]] then
            AnyPressedGrace = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys[config["GraceGamepadHotkey"]])
        end
        local AnyPressedLeon = false
        if config and gamepadKeys[config["LeonGamepadHotkey"]] then
            AnyPressedLeon = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys[config["LeonGamepadHotkey"]])
        end
        --local y_pressed = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys.Y)
        local r3_pressed = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys.R3)
        local rb_pressed = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys.RB)
        local l3_pressed = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys.L3)
        local lt_pressed = is_button_pressed(button_state, gamepad_previous_buttons, gamepadKeys.LT)

        --[[if lb_held and a_pressed then
            SwitchView()
        end]]
        if AnyPressedGrace then
            SwitchViewGrace()
        end
        if AnyPressedLeon then
            SwitchViewLeon()
        end
        gamepad_previous_buttons = button_state
    end
end)

re.on_draw_ui(function()
    if imgui.tree_node("Switch Camera View Hotkeys") then
        local changed, value, start, ends = imgui.input_text("Grace KB Hotkey", config["GraceKeyboardHotkey"])
        if changed then
            config["GraceKeyboardHotkey"] = tostring(value)
            json.dump_file("SwitchViewHotkeys\\config.json", config, 4)
        end
        local changed, value, start, ends = imgui.input_text("Grace Gamepad Hotkey", config["GraceGamepadHotkey"])
        if changed then
            config["GraceGamepadHotkey"] = tostring(value)
            json.dump_file("SwitchViewHotkeys\\config.json", config, 4)
        end
        local changed, value, start, ends = imgui.input_text("Leon KB Hotkey", config["LeonKeyboardHotkey"])
        if changed then
            config["LeonKeyboardHotkey"] = tostring(value)
            json.dump_file("SwitchViewHotkeys\\config.json", config, 4)
        end
        local changed, value, start, ends = imgui.input_text("Leon Gamepad Hotkey", config["LeonGamepadHotkey"])
        if changed then
            config["LeonGamepadHotkey"] = tostring(value)
            json.dump_file("SwitchViewHotkeys\\config.json", config, 4)
        end
        if imgui.tree_node("Hotkeys To Use") then
            for i, v in pairs(KBKeys) do
                imgui.text(i)
            end
            for i, v in pairs(gamepadKeys) do
                imgui.text(i)
            end
            imgui.tree_pop()
        end
        imgui.tree_pop()
    end
end)