# 🌻 Plants vs. Zombies: Replanted Trainer

**Game Version:** v1.5.1469  
**Process:** `Replanted.exe` (64-bit)  
**Author:** [mul0](https://mul0.com/trainer/plants-vs-zombies-replanted/)  
**License:** The Unlicense  
**Language:** Delphi (VCL)  
**Last Updated:** 12/01/26 8:12:02 PM

---

## 🧠 Overview
This is an **unofficial game trainer** for *Plants vs. Zombies: Replanted*.  
It adds **21 gameplay options** to enhance your experience — from unlimited sun and health to fast waves and instant level completion.  
All features are implemented using **Delphi VCL** with a modern DPI-aware interface and memory patching via AOB scanning.

---

## 📢 What's New (v1.5.1469 Update)

**Updated January 13, 2026**  
- Full support for the latest game version **v1.5.1469** (updated from v1.5.1468)  
- 🎮 **Added gamepad support** for **Seed Panel ID Manager** (F12): now works with controllers (L1/R1 for cycling, R3 for random, etc.)  
- ⚡ Minor performance improvements and code optimizations for smoother operation  

---

## 🧩 Game Info

| Game | Version | Process | License Type | Date of Creation |
|:-----|:---------|:---------|:---------------|:----------------|
| Plants vs. Zombies: Replanted | v1.5.1469 | Replanted.exe | 64-bit | 12/01/26 8:12:02 PM |

---

## ⚙️ Features (Hotkeys)

| Hotkey | Feature | Description |
|:-------:|:---------|:-------------|
| Numpad 1 | Unlimited Sun | Infinite sun for planting |
| Numpad 2 | Unlimited Health | Plants never die |
| Numpad 3 | Unlimited Coins | Infinite money for the shop |
| Numpad 4 | Fast Plant Recovery | Plants recharge instantly |
| Numpad 5 | Fast Shooting | Plants shoot faster |
| Numpad 6 | Free Purchase | Buy plants for 0 sun |
| Numpad 7 | Plant Anywhere | Place plants on any surface |
| Numpad 8 | Instant Recharge | Instantly finish actions |
| Numpad 9 | Remove Conditions | No base plant requirement |
| F1 | Freeze Selected Tool | Keeps selected tool active |
| F2 | Peashooter Auto-Aim | Bullets track zombies |
| F3 | Explosive Bowling | Wall-nuts become bombs |
| F4 | Permanent Bonuses | Pickups never disappear |
| F5 | Auto Collect | Automatically collects items |
| F6 | Diamond Drops | All coins become diamonds |
| F7 | No Plant Squish | Prevents crushing |
| F8 | No Gravestones | Removes gravestones at start |
| F9 | Instant Level Win | Instantly completes level |
| F10 | Fast Zombie Waves | Reduces wave delay |
| F11 | Single Plant Start | One plant enough to start |
| F12 | Seed Panel ID Manager | Change or randomize plants |

---

## 🪄 How to Use

1. Start *Plants vs. Zombies: Replanted* and wait until gameplay is fully loaded.  
2. Launch the trainer **after** the game starts.  
3. When the process is detected, click the **🔗 Connect** button.  
4. Activate features using the listed hotkeys.  
5. Enjoy enhanced gameplay!  

> ⚠️ Some antivirus programs may detect trainers as false positives.  
> Temporarily disable your antivirus if it blocks the trainer.

---

## 📸 Screenshot

![Trainer Preview](https://mul0.com/wp-content/uploads/2025/12/Plants-vs.-Zombies-Replanted-Trainer-Cover.webp)

---

### 🧾 Notes
- Built with **Delphi VCL** and fully **DPI-aware**.  
- Designed for **educational and demonstration purposes only**.  
- Do not use in online or competitive modes.  

---

© 2025 mul0 — All rights released under **The Unlicense**.
