-- SwiftGod v1.0 - Burst release + strong anti-false-positive (combat hardened)
-- Credits to pinguluk and yakuzadeso for the base scripts (Infinite Swift and Swift ability triggers slow motion when in combat) 
-- Merged by Moyous
-- Editable values : 
-- BlinkSpeed - Base swift speed
-- SlowMoStart - Time dilation on inicial cast in combat
-- SlowMoMid - Time dilation for the full remaining time of the cast
-- MidDelay - Delay between inicial dilation and full time dilation

local DEBUG = true
local function log(msg) if DEBUG then print(msg) end end
local function nowSeconds() return os.clock() end

-- Swift
local EnableInfiniteSwift = true
local ShadowBlinkSpeed = 2500
local VERY_BIG_NUMBER = 999999999999999
local StopEndOffset = -1

local START_ID = 25
local STOP_IDS = { [28] = true, [29] = true }

local EVENT_ID_MIN = 1
local EVENT_ID_MAX = 80

local STOP_COOLDOWN_SECONDS = 0.25

-- Arm delays (mais conservador em combate)
local ARM_RELEASE_AFTER_OUTSIDE_COMBAT = 0.14
local ARM_RELEASE_AFTER_IN_COMBAT      = 0.95

-- Tempo mínimo segurando antes de permitir STOP (evita stop “cedo”)
local MIN_HOLD_TO_STOP_OUTSIDE = 0.18
local MIN_HOLD_TO_STOP_COMBAT  = 0.55

-- Burst detection
local BURST_STEP_WINDOW = 0.010
local BURST_MIN_COUNT   = 3
local BURST_MAX_AGE     = 0.030

-- Execute-gating (mais exigente em combate)
local EXEC_SILENCE_FOR_RELEASE_OUTSIDE = 0.08
local EXEC_SILENCE_FOR_RELEASE_COMBAT  = 0.18

-- Se execute tracking falhar, não parar cedo
local EXTRA_MIN_HOLD_IF_NO_EXEC_TRACKING = 1.10

-- Pending stop confirmation
local PENDING_STOP_CONFIRM_MS = 140
local PENDING_STOP_CANCEL_GRACE = 0.020

-- PATCH v2: key-up tail handling
local HELD_TAIL_IGNORE_SECONDS = 0.25     -- por quanto tempo NÃO cancelar pending se vier 27/28/29
local PENDING_FORCE_STOP_AFTER = 0.45     -- se passou disso e ainda pendente, força STOP (se não teve ReceiveExecute)

-- SlowMo (combat-only)
local EnableSlowMoSwift = true
local SlowMoToggleKey = Key.F
local SlowMoToggleModifier = ModifierKey.ALT
local SlowMoStartDilation = 0.15
local SlowMoMidDilation   = 0.25
local SlowMoMidDelayMs    = 1000

-- Internals
local shadowBlinkAbility = nil
local shadowBlinkAbilityRootMotion = nil
local BipedPlayer = nil
local GameplayStatics = nil

local swiftHeld = false
local lastDownTime = -999
local lastStopTime = -999

local InSlowMo = false
local SlowMoEnabled = true

local hooksRegistered = false
local hookCount = 0

-- Execute tracking
local lastReceiveExecuteTime = -999
local lastReceiveExecuteHook = "none"
local executeEverFired = false

-- Burst state
local lastEvtTime = -999
local burstCount = 0
local burstStartTime = -999
local burstHasStopId = false

-- Pending stop state
local pendingStop = false
local pendingStopAt = -999
local pendingStopReason = ""
local pendingStopDetails = ""
local lastAnyEventTime = -999
local lastHeldLikeEventTime = -999
local lastExecDuringPending = -999

-- Ring buffer diag (leve)
local EVENT_BUF_MAX = 18
local eventBuf = {}
local function pushEvent(id)
    local t = nowSeconds()
    eventBuf[#eventBuf + 1] = { t=t, id=id, held=swiftHeld, combat=(BipedPlayer and BipedPlayer.bInCombatMode) and true or false }
    if #eventBuf > EVENT_BUF_MAX then table.remove(eventBuf, 1) end
end
local function dumpRecentEvents()
    log("[SwiftCombo v8.8] Recent events:")
    for i=1, #eventBuf do
        local e = eventBuf[i]
        log(string.format("[SwiftCombo v8.8]   t=%.3f id=%d held=%s combat=%s", e.t, e.id, tostring(e.held), tostring(e.combat)))
    end
end

local function safeRegisterHook(path, fn)
    local ok = pcall(function() RegisterHook(path, fn) end)
    if ok then hookCount = hookCount + 1 end
    return ok
end

local function safeSetProperty(obj, prop, value)
    if obj == nil then return false end
    return pcall(function() obj:SetPropertyValue(prop, value) end)
end

local function EnsureGameplayStatics()
    if GameplayStatics == nil then
        GameplayStatics = StaticFindObject("/Script/Engine.Default__GameplayStatics")
    end
end

local function FindSwiftObjects()
    shadowBlinkAbility = StaticFindObject(
        "/Game/Pawn/Student/Abilities/Locomotion/ABL_ShadowBlink.Default__ABL_ShadowBlink_C:ablRootMotionModifiersTask_1"
    )
    shadowBlinkAbilityRootMotion = StaticFindObject(
        "/Game/Pawn/Student/Abilities/Locomotion/ABL_ShadowBlink.Default__ABL_ShadowBlink_C:ablRootMotionModifiersTask_1.RootMotionModifierProperties_DodgeRoll_0"
    )
end

local function ApplySwiftSpeed()
    if not EnableInfiniteSwift then return end
    if shadowBlinkAbilityRootMotion == nil then return end
    safeSetProperty(shadowBlinkAbilityRootMotion, "BlinkSpeed", ShadowBlinkSpeed)
    safeSetProperty(shadowBlinkAbilityRootMotion, "TurnToFaceInterpTime", VERY_BIG_NUMBER)
end

local function SetSwiftEndTime(offset)
    if not EnableInfiniteSwift then return end
    if shadowBlinkAbility == nil then return end
    safeSetProperty(shadowBlinkAbility, "m_EndTime", { ["Offset"] = offset })
end

local function ResetBurst()
    burstCount = 0
    burstStartTime = -999
    burstHasStopId = false
end

local function EndSlowMo()
    if not InSlowMo then return end
    EnsureGameplayStatics()
    if GameplayStatics and BipedPlayer then
        GameplayStatics:SetGlobalTimeDilation(BipedPlayer, 1)
    end
    InSlowMo = false
end

local function StartSlowMo()
    if not EnableSlowMoSwift or not SlowMoEnabled then return end
    EnsureGameplayStatics()
    if not (GameplayStatics and BipedPlayer) then return end
    if not BipedPlayer.bInCombatMode then return end

    if not InSlowMo then
        GameplayStatics:SetGlobalTimeDilation(BipedPlayer, SlowMoStartDilation)
        InSlowMo = true
        ExecuteWithDelay(math.floor(SlowMoMidDelayMs), function()
            if InSlowMo and SlowMoEnabled and BipedPlayer and BipedPlayer.bInCombatMode then
                GameplayStatics:SetGlobalTimeDilation(BipedPlayer, SlowMoMidDilation)
            end
        end)
    end
end

local function StopSwift(reason, details)
    if not swiftHeld then return end
    swiftHeld = false
    lastStopTime = nowSeconds()
    SetSwiftEndTime(StopEndOffset)

    log("[SwiftCombo v8.8] STOP ("..tostring(reason)..")")
    if details and details ~= "" then log("[SwiftCombo v8.8]   "..details) end

    local t = nowSeconds()
    local heldDt = t - lastDownTime
    local execSilence = t - lastReceiveExecuteTime
    log(string.format("[SwiftCombo v8.8]   heldDt=%.3fs inCombat=%s execSilence=%.3fs lastExec=%s execEver=%s",
        heldDt,
        tostring((BipedPlayer and BipedPlayer.bInCombatMode) and true or false),
        execSilence,
        tostring(lastReceiveExecuteHook),
        tostring(executeEverFired)
    ))

    EndSlowMo()
    ResetBurst()

    pendingStop = false
    pendingStopAt = -999
    pendingStopReason = ""
    pendingStopDetails = ""
    lastExecDuringPending = -999

    dumpRecentEvents()
end

local function StartSwift()
    local t = nowSeconds()
    if (t - lastStopTime) < STOP_COOLDOWN_SECONDS then return end
    swiftHeld = true
    lastDownTime = t
    SetSwiftEndTime(VERY_BIG_NUMBER)
    log("[SwiftCombo v8.8] START (id=25)")
    ResetBurst()
    lastEvtTime = t
end

-- SlowMo toggle
RegisterKeyBind(SlowMoToggleKey, { SlowMoToggleModifier }, function()
    SlowMoEnabled = not SlowMoEnabled
    if not SlowMoEnabled then EndSlowMo() end
    print("[SwiftCombo v8.8] SlowMoEnabled=" .. tostring(SlowMoEnabled))
end)

local function UpdateBurstAndCheckRelease(id, t)
    local dt = t - lastEvtTime
    lastEvtTime = t

    if dt <= BURST_STEP_WINDOW then
        burstCount = burstCount + 1
    else
        burstCount = 1
        burstStartTime = t
        burstHasStopId = false
    end

    if STOP_IDS[id] then burstHasStopId = true end

    local burstAge = t - burstStartTime
    if burstCount >= BURST_MIN_COUNT and burstHasStopId and burstAge <= BURST_MAX_AGE then
        return true, burstCount, burstAge
    end
    return false, burstCount, burstAge
end

local function inCombat()
    return (BipedPlayer and BipedPlayer.bInCombatMode) and true or false
end

local function armDelay()
    return inCombat() and ARM_RELEASE_AFTER_IN_COMBAT or ARM_RELEASE_AFTER_OUTSIDE_COMBAT
end

local function minHoldToStop()
    return inCombat() and MIN_HOLD_TO_STOP_COMBAT or MIN_HOLD_TO_STOP_OUTSIDE
end

local function execSilenceGate()
    return inCombat() and EXEC_SILENCE_FOR_RELEASE_COMBAT or EXEC_SILENCE_FOR_RELEASE_OUTSIDE
end

-- PATCH v2: re-checker que permite “tail” e força stop com segurança
local function PendingRecheck()
    if not pendingStop then return end
    if not swiftHeld then pendingStop = false return end

    local t = nowSeconds()

    if lastExecDuringPending > 0 then
        log("[SwiftCombo v8.8] PENDING cancelled (ReceiveExecute happened)")
        pendingStop = false
        return
    end

    local sinceHeld = t - lastHeldLikeEventTime
    local pendingAge = t - pendingStopAt

    -- força stop depois de um limite (resolve “não cancela ao soltar”)
    if pendingAge >= PENDING_FORCE_STOP_AFTER then
        StopSwift(pendingStopReason .. " (force)", pendingStopDetails .. string.format(" pendingAge=%.3f sinceHeld=%.3f", pendingAge, sinceHeld))
        return
    end

    -- ainda chegam held-like? espera mais um pouco, não cancela definitivamente
    if sinceHeld < (PENDING_STOP_CONFIRM_MS / 1000.0) then
        -- re-checa em breve
        ExecuteWithDelay(60, PendingRecheck)
        return
    end

    -- ok, silêncio suficiente
    StopSwift(pendingStopReason, pendingStopDetails)
end

local function ArmPendingStop(reason, details)
    if pendingStop then return end
    pendingStop = true
    pendingStopAt = nowSeconds()
    pendingStopReason = reason
    pendingStopDetails = details or ""
    lastExecDuringPending = -999

    log("[SwiftCombo v8.8] PENDING STOP ("..reason..")")

    ExecuteWithDelay(math.floor(PENDING_STOP_CONFIRM_MS), PendingRecheck)
end

local function HandleInputEvent(id)
    local t = nowSeconds()

    pushEvent(id)
    lastAnyEventTime = t

    local isHeldLike = (id == 27 or id == 28 or id == 29)
    if isHeldLike then
        lastHeldLikeEventTime = t
    end

    -- PATCH v2: se tiver pending, NÃO cancelar por held-like por um tempo curto (tail do key-up)
    if pendingStop and (t - pendingStopAt) > PENDING_STOP_CANCEL_GRACE then
        if isHeldLike and (t - pendingStopAt) <= HELD_TAIL_IGNORE_SECONDS then
            -- ignora (não cancela pending)
        else
            log("[SwiftCombo v8.8] PENDING cancelled by input (id="..tostring(id)..")")
            pendingStop = false
        end
    end

    if (t - lastStopTime) < STOP_COOLDOWN_SECONDS then return end

    if not swiftHeld then
        if id == START_ID then StartSwift() end
        return
    end

    local heldDt = t - lastDownTime
    if heldDt < armDelay() then
        ResetBurst()
        return
    end

    if heldDt < minHoldToStop() then
        ResetBurst()
        return
    end

    local isReleaseBurst, bc, age = UpdateBurstAndCheckRelease(id, t)
    if not isReleaseBurst then return end

    -- PATCH: NÃO parar antes do ReceiveExecute deste START
    if lastReceiveExecuteTime < lastDownTime then
        log(string.format("[SwiftCombo v8.8] Burst ignored (no ReceiveExecute since START) heldDt=%.3f lastId=%d", heldDt, id))
        ResetBurst()
        return
    end

    local execTrackingOk = executeEverFired
    local execSilence = t - lastReceiveExecuteTime

    if not execTrackingOk then
        if heldDt < EXTRA_MIN_HOLD_IF_NO_EXEC_TRACKING then
            log(string.format("[SwiftCombo v8.8] Burst ignored (NO EXEC TRACK) heldDt=%.3f lastId=%d", heldDt, id))
            ResetBurst()
            return
        end
        ArmPendingStop("release-burst (NO EXEC)", string.format("count=%d age=%.3f heldDt=%.3f lastId=%d", bc, age, heldDt, id))
        ResetBurst()
        return
    end

    local gate = execSilenceGate()
    if execSilence < gate then
        log(string.format("[SwiftCombo v8.8] Burst ignored (execSilence=%.3f < %.3f) heldDt=%.3f lastId=%d",
            execSilence, gate, heldDt, id))
        ResetBurst()
        return
    end

    ArmPendingStop("release-burst", string.format("count=%d age=%.3f execSilence=%.3f heldDt=%.3f lastId=%d",
        bc, age, execSilence, heldDt, id))
    ResetBurst()
end

local function RegisterInputHooks()
    local base = "/Game/Pawn/Shared/StateTree/BTS_Biped_TopLevel.BTS_Biped_TopLevel_C:InpActEvt_DodgeAndBlinkButton_K2Node_CustomInputActionEvent_"
    for id = EVENT_ID_MIN, EVENT_ID_MAX do
        safeRegisterHook(base .. tostring(id), function()
            HandleInputEvent(id)
        end)
    end
    print("[SwiftCombo v8.8] Input hooks registered: " .. tostring(hookCount))
end

local function RegisterShadowBlinkExecuteHooks()
    local prefixes = {
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink.BTT_Biped_ShadowBlink_C:ReceiveExecute",
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink_1.BTT_Biped_ShadowBlink_1_C:ReceiveExecute",
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink_2.BTT_Biped_ShadowBlink_2_C:ReceiveExecute",
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink_3.BTT_Biped_ShadowBlink_3_C:ReceiveExecute",
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink_4.BTT_Biped_ShadowBlink_4_C:ReceiveExecute",
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink_5.BTT_Biped_ShadowBlink_5_C:ReceiveExecute",
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink_6.BTT_Biped_ShadowBlink_6_C:ReceiveExecute",
    }

    local okCount = 0
    for _, path in ipairs(prefixes) do
        local ok = safeRegisterHook(path, function()
            lastReceiveExecuteTime = nowSeconds()
            lastReceiveExecuteHook = path
            executeEverFired = true

            if pendingStop then
                lastExecDuringPending = lastReceiveExecuteTime
            end

            if EnableInfiniteSwift and swiftHeld then
                SetSwiftEndTime(VERY_BIG_NUMBER)
            end

            if EnableSlowMoSwift and SlowMoEnabled then
                StartSlowMo()
            end
        end)
        if ok then okCount = okCount + 1 end
    end

    print("[SwiftCombo v8.8] ShadowBlink ReceiveExecute hooks registered: " .. tostring(okCount))
end

local function RegisterExitTaskHook()
    safeRegisterHook(
        "/Game/Pawn/Shared/StateTree/BTT_Biped_ShadowBlink_2.BTT_Biped_ShadowBlink_2_C:ExitTask",
        function()
            EndSlowMo()
        end
    )
end

local function RegisterAll()
    if hooksRegistered then return end
    hooksRegistered = true
    RegisterInputHooks()
    RegisterShadowBlinkExecuteHooks()
    RegisterExitTaskHook()
    print("[SwiftCombo v8.8] Hooks ready.")
end

RegisterHook("/Script/Engine.PlayerController:ClientRestart", function(Context, NewPawn)
    BipedPlayer = Context:get().Pawn
end)

RegisterHook("/Script/Phoenix.Biped_Player:OnCharacterLoadComplete", function(self)
    print("========== SwiftCombo v8.8 LOADED ==========")

    swiftHeld = false
    InSlowMo = false
    lastDownTime = -999
    lastStopTime = -999

    lastReceiveExecuteTime = -999
    lastReceiveExecuteHook = "none"
    executeEverFired = false

    lastEvtTime = -999
    ResetBurst()

    pendingStop = false
    pendingStopAt = -999
    pendingStopReason = ""
    pendingStopDetails = ""
    lastAnyEventTime = -999
    lastHeldLikeEventTime = -999
    lastExecDuringPending = -999

    eventBuf = {}
    hookCount = 0

    FindSwiftObjects()
    ApplySwiftSpeed()
    RegisterAll()

    print("[SwiftCombo v8.8] Ready.")
end)