using TaleWorlds.CampaignSystem;
using TaleWorlds.CampaignSystem.GameComponents;
using TaleWorlds.Core;
using TaleWorlds.Localization;

namespace LifelongLearning
{
    public class LifelongLearningModel : DefaultCharacterDevelopmentModel
    {
        private const float MinimumLearningRate = 0.5f;

        public override ExplainedNumber CalculateLearningRate(
            IReadOnlyPropertyOwner<CharacterAttribute> characterAttributes, 
            int focusValue, 
            int skillValue, 
            SkillObject skill, 
            bool includeDescriptions = false)
        {
            // Get the base game's calculated learning rate
            ExplainedNumber result = base.CalculateLearningRate(characterAttributes, focusValue, skillValue, skill, includeDescriptions);

            // If the learning rate is below our minimum, replace LimitMin with our minimum
            if (result.ResultNumber < MinimumLearningRate)
            {
                result.LimitMin(MinimumLearningRate);
            }

            return result;
        }
    }
}
